#ifndef VIMEO_H
#define VIMEO_H

#include "../../cutetubeapp/src/base/enums.h"
#include <QObject>
#include <QString>
#include <QUrl>

class QNetworkAccessManager;
class QNetworkReply;

class Vimeo : public QObject
{
    Q_OBJECT

public:
    explicit Vimeo(QObject *parent = 0);
    ~Vimeo();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_user; }
    inline bool userSignedIn() const { return !this->accessToken().isEmpty(); }
    QNetworkReply* createReply(QString feed, int offset = 0);
    inline QString accessToken() const { return m_token; }

public slots:
    void setAccount(const QString &user = QString(), const QString &token = QString(), const QString &secret = QString());
    inline void setUsername(const QString &user) { m_user = user; emit usernameChanged(user); }

private:
    QByteArray getOAuthHeader(const QString &method, const QUrl &url, QMap<QString, QString> params);
    inline QString tokenSecret() const { return m_tokenSecret; }
    inline void setTokenSecret(const QString &secret) { m_tokenSecret = secret; }
    inline void setAccessToken(const QString &token) { m_token = token; emit userSignedInChanged(); }

signals:
    void usernameChanged(const QString &username);
    void userSignedInChanged();
    void newAccountSet();

private:
    QNetworkAccessManager *m_nam;
    QString m_clientId;
    QString m_clientSecret;
    QString m_redirectUri;
    QString m_user;
    QString m_token;
    QString m_tokenSecret;
};

#endif // VIMEO_H
