#include "database.h"
#include <QDir>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlError>
#include <QDebug>
#include <QVariant>

Database::Database(QObject *parent) :
    QObject(parent)
{
    QDir dir;
    dir.mkpath("/home/user/cuteTube/");
    m_database = QSqlDatabase::addDatabase("QSQLITE");
    m_database.setDatabaseName("/home/user/cuteTube/cuteTube.sqlite");
    initialize();
}

void Database::initialize() {
    if (m_database.open()) {
        m_database.exec("CREATE TABLE IF NOT EXISTS youtubeAccounts (name TEXT UNIQUE, username TEXT, token TEXT, refresh TEXT, cookies TEXT, active INTEGER)");
        m_database.exec("CREATE TABLE IF NOT EXISTS dailymotionAccounts (name TEXT UNIQUE, username TEXT, token TEXT, refresh TEXT, cookies TEXT, active INTEGER)");
        m_database.exec("CREATE TABLE IF NOT EXISTS vimeoAccounts (name TEXT UNIQUE, username TEXT, token TEXT, secret TEXT, cookies TEXT, active INTEGER)");
        m_database.close();
    }
    else {
        qDebug() << m_database.lastError().text();
    }
}

void Database::restoreAccounts() {
    this->restoreYouTubeAccount();
    this->restoreDailymotionAccount();
    this->restoreVimeoAccount();
}

bool Database::setYouTubeUsername(const QString &user) {
    if ((m_database.isOpen()) || (m_database.open())) {
        QSqlQuery query;
        query.prepare("UPDATE youtubeAccounts SET username = ? WHERE active = 1");
        query.addBindValue(user);

        bool success = query.exec();

        if (!success) {
            emit error(tr("Database error. Unable to store YouTube account details"));
        }

        m_database.close();

        return success;
    }
    else {
        emit error(tr("Database error. Unable to store YouTube account details"));

        return false;
    }
}

bool Database::setYouTubeAccessToken(const QString &token) {
    if ((m_database.isOpen()) || (m_database.open())) {
        QSqlQuery query;
        query.prepare("UPDATE youtubeAccounts SET token = ? WHERE active = 1");
        query.addBindValue(token);

        bool success = query.exec();

        if (!success) {
            emit error(tr("Database error. Unable to store YouTube account details"));
        }

        m_database.close();

        return success;
    }
    else {
        emit error(tr("Database error. Unable to store YouTube account details"));

        return false;
    }
}

void Database::restoreYouTubeAccount() {
    if ((m_database.isOpen()) || (m_database.open())) {
        QString user;
        QString token;
        QString refresh;
        QSqlQuery query;
        QSqlRecord record;
        query.exec("SELECT username, token, refresh FROM youtubeAccounts WHERE active = 1");
        record = query.record();

        if (record.count() > 0) {
            while (query.next()) {
                user = query.value(0).toString();
                token = query.value(1).toString();
                refresh = query.value(2).toString();
            }
        }

        m_database.close();

        if (!token.isEmpty()) {
            emit gotYouTubeAccount(user, token, refresh);
        }
    }
}

bool Database::setDailymotionUsername(const QString &user) {
    if ((m_database.isOpen()) || (m_database.open())) {
        QSqlQuery query;
        query.prepare("UPDATE dailymotionAccounts SET username = ? WHERE active = 1");
        query.addBindValue(user);

        bool success = query.exec();

        if (!success) {
            emit error(tr("Database error. Unable to store Dailymotion account details"));
        }

        m_database.close();

        return success;
    }
    else {
        emit error(tr("Database error. Unable to store Dailymotion account details"));

        return false;
    }
}

bool Database::setDailymotionAccessToken(const QString &token, const QString &refresh) {
    if ((m_database.isOpen()) || (m_database.open())) {
        QSqlQuery query;
        query.prepare("UPDATE dailymotionAccounts SET token = ?, refresh = ? WHERE active = 1");
        query.addBindValue(token);
        query.addBindValue(refresh);

        bool success = query.exec();

        if (!success) {
            emit error(tr("Database error. Unable to store Dailymotion account details"));
        }

        m_database.close();

        return success;
    }
    else {
        emit error(tr("Database error. Unable to store Dailymotion account details"));

        return false;
    }
}

void Database::restoreDailymotionAccount() {
    if ((m_database.isOpen()) || (m_database.open())) {
        QString user;
        QString token;
        QString refresh;
        QSqlQuery query;
        QSqlRecord record;
        query.exec("SELECT username, token, refresh FROM dailymotionAccounts WHERE active = 1");
        record = query.record();

        if (record.count() > 0) {
            while (query.next()) {
                user = query.value(0).toString();
                token = query.value(1).toString();
                refresh = query.value(2).toString();
            }
        }

        m_database.close();

        if (!token.isEmpty()) {
            emit gotDailymotionAccount(user, token, refresh);
        }
    }
}

bool Database::setVimeoUsername(const QString &user) {
    if ((m_database.isOpen()) || (m_database.open())) {
        QSqlQuery query;
        query.prepare("UPDATE vimeoAccounts SET username = ? WHERE active = 1");
        query.addBindValue(user);

        bool success = query.exec();

        if (!success) {
            emit error(tr("Database error. Unable to store Vimeo account details"));
        }

        m_database.close();

        return success;
    }
    else {
        emit error(tr("Database error. Unable to store Vimeo account details"));

        return false;
    }
}

bool Database::setVimeoAccessToken(const QString &token, const QString &secret) {
    if ((m_database.isOpen()) || (m_database.open())) {
        QSqlQuery query;
        query.prepare("UPDATE vimeoAccounts SET token = ?, secret = ? WHERE active = 1");
        query.addBindValue(token);
        query.addBindValue(secret);

        bool success = query.exec();

        if (!success) {
            emit error(tr("Database error. Unable to store Vimeo account details"));
        }

        m_database.close();

        return success;
    }
    else {
        emit error(tr("Database error. Unable to store Vimeo account details"));

        return false;
    }
}

void Database::restoreVimeoAccount() {
    if ((m_database.isOpen()) || (m_database.open())) {
        QString user;
        QString token;
        QString secret;
        QSqlQuery query;
        QSqlRecord record;
        query.exec("SELECT username, token, secret FROM vimeoAccounts WHERE active = 1");
        record = query.record();

        if (record.count() > 0) {
            while (query.next()) {
                user = query.value(0).toString();
                token = query.value(1).toString();
                secret = query.value(2).toString();
            }
        }

        m_database.close();

        if (!token.isEmpty()) {
            emit gotVimeoAccount(user, token, secret);
        }
    }
}
