#include "youtubevideoselectionwindow.h"
#include "videoselectiondelegate.h"
#include "youtubeplaylistdialog.h"
#include "../base/youtubevideolistmodel.h"
#include "../base/session.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>

YouTubeVideoSelectionWindow::YouTubeVideoSelectionWindow(Session *session, YouTubeVideoListModel *model, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_model(model),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select videos"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowFlags(Qt::Window);
    this->setWindowState(Qt::WindowFullScreen);
    this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VideoSelectionDelegate(m_listView));

    m_editBar->addButton(m_acceptButton);
    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    this->connect(this, SIGNAL(accepted()), this, slot);
}

YouTubeVideoSelectionWindow::~YouTubeVideoSelectionWindow() {
    m_model->selectNone();
}

void YouTubeVideoSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void YouTubeVideoSelectionWindow::onItemClicked(const QModelIndex &index) {
    m_model->toggleSelected(index.row());
}

void YouTubeVideoSelectionWindow::onButtonClicked() {
    if (m_model->itemsSelected()) {
        emit accepted();
    }
}

void YouTubeVideoSelectionWindow::deleteVideosFromUploads() {
    m_model->deleteSelectedVideosFromUploads();
    this->close();
}

void YouTubeVideoSelectionWindow::addVideosToFavourites() {
    m_model->addSelectedVideosToFavourites();
    this->close();
}

void YouTubeVideoSelectionWindow::deleteVideosFromFavourites() {
    m_model->deleteSelectedVideosFromFavourites();
    this->close();
}

void YouTubeVideoSelectionWindow::showPlaylistDialog() {
    YouTubePlaylistDialog *dialog = new YouTubePlaylistDialog(m_session, this);
    dialog->open();

    this->connect(dialog, SIGNAL(playlistChosen(QString)), this, SLOT(addVideosToPlaylist(QString)));
    this->connect(dialog, SIGNAL(addToNewPlaylist(QVariantMap)), this, SLOT(addVideosToNewPlaylist(QVariantMap)));
}

void YouTubeVideoSelectionWindow::addVideosToPlaylist(const QString &id) {
    m_model->addSelectedVideosToPlaylist(id);
    this->close();
}

void YouTubeVideoSelectionWindow::addVideosToNewPlaylist(const QVariantMap &playlist) {
    m_model->addSelectedVideosToNewPlaylist(playlist);
    this->close();
}

void YouTubeVideoSelectionWindow::deleteVideosFromPlaylist() {
    m_model->deleteSelectedVideosFromPlaylist(m_model->playlistId());
    this->close();
}

void YouTubeVideoSelectionWindow::addVideosToWatchLaterPlaylist() {
    m_model->addSelectedVideosToWatchLaterPlaylist();
    this->close();
}

void YouTubeVideoSelectionWindow::deleteVideosFromWatchLaterPlaylist() {
    m_model->deleteSelectedVideosFromWatchLaterPlaylist();
    this->close();
}

void YouTubeVideoSelectionWindow::addVideoDownloads() {
    m_model->downloadSelectedVideos();
    this->close();
}

void YouTubeVideoSelectionWindow::addAudioDownloads() {
    m_model->downloadSelectedVideos(true);
    this->close();
}

void YouTubeVideoSelectionWindow::queueVideos() {
    m_model->queueSelectedVideos();
    this->close();
}
