#ifndef YOUTUBEVIDEODESCRIPTIONTAB_H
#define YOUTUBEVIDEODESCRIPTIONTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class Session;
class ThumbnailLabel;
class QAction;
class QLabel;
class QPushButton;
class QScrollArea;
class QGridLayout;

class YouTubeVideoDescriptionTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeVideoDescriptionTab(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void setMenuActions();

private slots:
    void showEditMetadataDialog();
    void toggleFavourite();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoToWatchLaterPlaylist();
    void addVideoToPlaybackQueue();
    void addVideoDownload();
    void addAudioDownload();
    void likeVideo();
    void dislikeVideo();
    void onVideoLiked();
    void onVideoDisliked();
    void onFavouriteChanged(bool favourite);
    void playVideo();
    void setThumbnails();
    void showShareDialog();
    void shareVideo(Services::SharingService service);
    void showFacebookDialog();
    void showTwitterDialog();
    void search(const QString &query);
    void showUserChannel();
    
private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QAction *m_editAction;
    QAction *m_favouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_watchLaterAction;
    QAction *m_queueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QAction *m_shareAction;
    QPushButton *m_likeButton;
    QPushButton *m_dislikeButton;
    ThumbnailLabel *m_thumbnail;
    ThumbnailLabel *m_avatar;
    QLabel *m_titleLabel;
    QLabel *m_dateLabel;
    QLabel *m_likesLabel;
    QLabel *m_dislikesLabel;
    QLabel *m_viewsLabel;
    QLabel *m_descriptionLabel;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBEVIDEODESCRIPTIONTAB_H
