#ifndef YOUTUBEPLAYLISTLISTTAB_H
#define YOUTUBEPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class Session;
class ListView;
class YouTubePlaylistListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class YouTubePlaylistListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit YouTubePlaylistListTab(Session *session, QWidget *parent = 0);
    void setPlaylistFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    Session *m_session;
    ListView *m_listView;
    YouTubePlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPLAYLISTLISTTAB_H
