#include "youtubemychannelwindow.h"
#include "youtubeprofiletab.h"
#include "youtubevideolisttab.h"
#include "youtubeuserplaylistlisttab.h"
#include "youtubesubscriptionstab.h"
#include "../base/session.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>

YouTubeMyChannelWindow::YouTubeMyChannelWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_favouritesAction(new QAction("Fav", this)),
    m_recommendedAction(new QAction("Rec", this)),
    m_playlistsAction(new QAction("Play", this)),
    m_subscriptionsAction(new QAction("Subs", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new YouTubeProfileTab(m_session, "me", m_tabWidget)),
    m_uploadsTab(0),
    m_favouritesTab(0),
    m_recommendedTab(0),
    m_playlistsTab(0),
    m_subscriptionsTab(0)
{
    this->setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_favouritesAction->setCheckable(true);
    m_favouritesAction->setActionGroup(m_actionGroup);

    m_recommendedAction->setCheckable(true);
    m_recommendedAction->setActionGroup(m_actionGroup);

    m_playlistsAction->setCheckable(true);
    m_playlistsAction->setActionGroup(m_actionGroup);

    m_subscriptionsAction->setCheckable(true);
    m_subscriptionsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_favouritesAction);
    m_menu->addAction(m_recommendedAction);
    m_menu->addAction(m_playlistsAction);
    m_menu->addAction(m_subscriptionsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    this->connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    this->connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    this->connect(m_favouritesAction, SIGNAL(triggered()), this, SLOT(showFavourites()));
    this->connect(m_recommendedAction, SIGNAL(triggered()), this, SLOT(showRecommended()));
    this->connect(m_playlistsAction, SIGNAL(triggered()), this, SLOT(showPlaylists()));
    this->connect(m_subscriptionsAction, SIGNAL(triggered()), this, SLOT(showSubscriptions()));

    this->showProfile();
    this->onOrientationChanged();
}

void YouTubeMyChannelWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void YouTubeMyChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    this->setWindowTitle(tr("Profile"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_profileTab->actions());
}

void YouTubeMyChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new YouTubeVideoListTab(m_session, this);
        m_uploadsTab->setVideoFeed(YOUTUBE_UPLOADS_FEED);
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    this->setWindowTitle(tr("Uploads"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_uploadsTab->actions());
}

void YouTubeMyChannelWindow::showFavourites() {
    if (!m_favouritesTab) {
        m_favouritesTab = new YouTubeVideoListTab(m_session, this);
        m_favouritesTab->setVideoFeed(YOUTUBE_FAVOURITES_FEED);
        m_tabWidget->addWidget(m_favouritesTab);
    }

    m_tabWidget->setCurrentWidget(m_favouritesTab);
    this->setWindowTitle(tr("Favourites"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_favouritesTab->actions());
}

void YouTubeMyChannelWindow::showRecommended() {
    if (!m_recommendedTab) {
        m_recommendedTab = new YouTubeVideoListTab(m_session, this);
        m_recommendedTab->setVideoFeed(YOUTUBE_RECOMMENDED_FEED);
        m_tabWidget->addWidget(m_recommendedTab);
    }

    m_tabWidget->setCurrentWidget(m_recommendedTab);
    this->setWindowTitle(tr("Recommended"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_recommendedTab->actions());
}

void YouTubeMyChannelWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new YouTubeUserPlaylistListTab(m_session, this);
        m_tabWidget->addWidget(m_playlistsTab);
    }

    m_tabWidget->setCurrentWidget(m_playlistsTab);
    this->setWindowTitle(tr("Playlists"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_playlistsTab->actions());
}

void YouTubeMyChannelWindow::showSubscriptions() {
    if (!m_subscriptionsTab) {
        m_subscriptionsTab = new YouTubeSubscriptionsTab(m_session, this);
        m_tabWidget->addWidget(m_subscriptionsTab);
    }

    m_tabWidget->setCurrentWidget(m_subscriptionsTab);
    this->setWindowTitle(tr("Subscriptions"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_subscriptionsTab->actions());
}
