#ifndef YOUTUBECHANNELWINDOW_H
#define YOUTUBECHANNELWINDOW_H

#include "stackedwindow.h"

class YouTubeProfileTab;
class YouTubeVideoListTab;
class YouTubePlaylistListTab;
class YouTubeUserListTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class YouTubeChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit YouTubeChannelWindow(Session *session, const QString &userId, QWidget *parent);
    
private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showFavourites();
    void showPlaylists();
    void showSubscriptions();

private:
    QString m_userId;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_favouritesAction;
    QAction *m_playlistsAction;
    QAction *m_subscriptionsAction;
    QStackedWidget *m_tabWidget;
    YouTubeProfileTab *m_profileTab;
    YouTubeVideoListTab *m_uploadsTab;
    YouTubeVideoListTab *m_favouritesTab;
    YouTubePlaylistListTab *m_playlistsTab;
    YouTubeUserListTab *m_subscriptionsTab;
};
    
#endif // YOUTUBECHANNELWINDOW_H
