#ifndef VIMEOVIDEODESCRIPTIONTAB_H
#define VIMEOVIDEODESCRIPTIONTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class Session;
class ThumbnailLabel;
class QAction;
class QLabel;
class QScrollArea;
class QGridLayout;

class VimeoVideoDescriptionTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit VimeoVideoDescriptionTab(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void setMenuActions();
    QString tagsToString(QStringList tags);

private slots:
    void toggleLike();
    void onLikeChanged(bool like);
    void onLikesChanged(int likes);
    void showAlbumDialog();
    void addVideoToAlbum(const QString &id);
    void addVideoToNewAlbum(const QVariantMap &album);
    void addVideoToPlaybackQueue();
    void addVideoDownload();
    void addAudioDownload();
    void playVideo();
    void setThumbnails();
    void showShareDialog();
    void shareVideo(Services::SharingService service);
    void showFacebookDialog();
    void showTwitterDialog();
    void search(const QString &query);
    void showUserChannel();

private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QAction *m_likeAction;
    QAction *m_addToAlbumAction;
    QAction *m_queueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QAction *m_shareAction;
    ThumbnailLabel *m_thumbnail;
    ThumbnailLabel *m_avatar;
    QLabel *m_titleLabel;
    QLabel *m_dateLabel;
    QLabel *m_likesLabel;
    QLabel *m_viewsLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_tagsLabel;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // VIMEOVIDEODESCRIPTIONTAB_H
