#ifndef VIMEOUSERLISTTAB_H
#define VIMEOUSERLISTTAB_H

#include "abstracttab.h"

class Session;
class VimeoUserListModel;
class ListView;
class QLabel;
class QGridLayout;
class QModelIndex;

class VimeoUserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit VimeoUserListTab(Session *session, const QString &userId, QWidget *parent = 0);
    void setFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);

private:
    Session *m_session;
    QString m_userId;
    VimeoUserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEOUSERLISTTAB_H
