#include "vimeosubscriptionstab.h"
#include "vimeouserlistdelegate.h"
#include "vimeochannelwindow.h"
#include "vimeovideolistwindow.h"
#include "../base/vimeosubscriptionlistmodel.h"
#include "../base/session.h"
#include "listview.h"
#include <QMenu>
#include <QAction>
#include <QLabel>
#include <QGridLayout>

VimeoSubscriptionsTab::VimeoSubscriptionsTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_model(new VimeoSubscriptionListModel(session, this)),
    m_listView(new ListView(this)),
    m_contextMenu(new QMenu(this)),
    m_unsubscribeAction(m_contextMenu->addAction(tr("Unsubscribe"), this, SLOT(unsubscribe()))),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new VimeoUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (m_session->vimeo()->subscriptionsLoaded()) {
        this->onSubscriptionsLoaded();
    }
    else {
        m_session->toggleBusy(true);
        this->connect(m_session->vimeo(), SIGNAL(allSubscriptionsLoaded()), this, SLOT(onSubscriptionsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    this->onOrientationChanged();
}

void VimeoSubscriptionsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoSubscriptionsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoSubscriptionsTab::onSubscriptionsLoaded() {
    m_session->toggleBusy(false);
    m_listView->setModel(m_model);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void VimeoSubscriptionsTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void VimeoSubscriptionsTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(VimeoSubscriptionListModel::IdRole).toString());
    }
}

void VimeoSubscriptionsTab::showUserChannel(const QString &userId) {
    VimeoChannelWindow *window = new VimeoChannelWindow(m_session, userId, m_session->currentWindow());
    window->show();
}

void VimeoSubscriptionsTab::showSubscriptionVideos() {
    VimeoVideoListWindow *window = new VimeoVideoListWindow(m_session, m_session->currentWindow());
    window->setWindowTitle(tr("Latest subscription videos"));
    window->setVideoFeed(VIMEO_NEW_SUBSCRIPTION_VIDEOS_FEED);
    window->show();
}

void VimeoSubscriptionsTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_unsubscribeAction);
}

void VimeoSubscriptionsTab::unsubscribe() {
    m_session->vimeo()->unsubscribe(m_model->data(m_listView->currentIndex(), VimeoSubscriptionListModel::IdRole).toString());
}
