#include "vimeoalbumdialog.h"
#include "vimeoalbumlistdelegate.h"
#include "vimeonewalbumdialog.h"
#include "../base/vimeouseralbumlistmodel.h"
#include "listview.h"
#include "../base/session.h"
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>
#include <QGridLayout>

VimeoAlbumDialog::VimeoAlbumDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_model(new VimeoUserAlbumListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_newButton(m_buttonBox->addButton(tr("New album"), QDialogButtonBox::ActionRole)),
    m_noResultsLabel(new QLabel(tr("No albums found"), this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Add to album"));
    this->toggleBusy(true);

    m_listView->setItemDelegate(new VimeoAlbumListDelegate(m_listView));

    QFont font;
    font.setPixelSize(40);
    font.setBold(true);
    m_noResultsLabel->setFont(font);
    m_noResultsLabel->setAlignment(Qt::AlignCenter);
    m_noResultsLabel->hide();

    this->connect(m_newButton, SIGNAL(clicked()), this, SLOT(showNewAlbumDialog()));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    if (m_session->vimeo()->albumsLoaded()) {
        this->onAlbumsLoaded();
    }
    else {
        this->connect(m_session->vimeo(), SIGNAL(allAlbumsLoaded()), this, SLOT(onAlbumsLoaded()));
    }

    this->onOrientationChanged();
}

void VimeoAlbumDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_noResultsLabel->setFixedSize(800, 340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void VimeoAlbumDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_noResultsLabel->setFixedSize(480, 600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void VimeoAlbumDialog::onAlbumsLoaded() {
    this->toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);
}

void VimeoAlbumDialog::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        emit albumChosen(index.data(VimeoUserAlbumListModel::IdRole).toString());
        this->accept();
    }
}

void VimeoAlbumDialog::showNewAlbumDialog() {
    VimeoNewAlbumDialog *dialog = new VimeoNewAlbumDialog(this);
    dialog->open();
    this->connect(dialog, SIGNAL(albumCreated(QVariantMap)), this, SIGNAL(addToNewAlbum(QVariantMap)));
    this->connect(dialog, SIGNAL(accepted()), this, SLOT(accept()));
}
