#include "videoplayerbutton.h"
#include <QPainter>

VideoPlayerButton::VideoPlayerButton(Role buttonRole, QWidget *parent) :
    QAbstractButton(parent),
    m_role(buttonRole)
{
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    this->setStyleSheet("background:transparent");
    this->setFixedSize(70, 70);
}

void VideoPlayerButton::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QPainter painter(this);

    switch (m_role) {
    case Previous:
        painter.drawImage(this->rect(), this->isDown() ? QImage("/etc/hildon/theme/mediaplayer/BackPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Back.png"));
        break;
    case Next:
        painter.drawImage(this->rect(), this->isDown() ? QImage("/etc/hildon/theme/mediaplayer/ForwardPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Forward.png"));
        break;
    default:
        this->icon().paint(&painter, this->rect());
        break;
    }
}
