#ifndef SOCIALVIDEOSELECTIONWINDOW_H
#define SOCIALVIDEOSELECTIONWINDOW_H

#include "../base/enums.h"
#include <QWidget>

class SocialVideoListModel;
class Session;
class ListView;
class QMaemo5EditBar;
class QPushButton;
class QVBoxLayout;
class QModelIndex;

class SocialVideoSelectionWindow : public QWidget
{
    Q_OBJECT
public:
    explicit SocialVideoSelectionWindow(Session *session, SocialVideoListModel *model, const QString &text, const char* slot, QWidget *parent);
    ~SocialVideoSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();

signals:
    void accepted();

private:
    Session *m_session;
    SocialVideoListModel *m_model;
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // SOCIALVIDEOSELECTIONWINDOW_H
