#ifndef SOCIALVIDEOLISTWINDOW_H
#define SOCIALVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/videoitem.h"

class Session;
class SocialVideoListModel;
class ListView;
class QAction;
class QLabel;
class QModelIndex;

class SocialVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit SocialVideoListWindow(Session *session, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onCountChanged(int count);
    void refresh();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);

private:
    ListView *m_listView;
    SocialVideoListModel *m_model;
    QAction *m_refreshAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // SOCIALVIDEOLISTWINDOW_H
