#include "sharetofacebookdialog.h"
#include "../base/session.h"
#include <QLineEdit>
#include <QTextEdit>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>
#include <QLabel>

ShareToFacebookDialog::ShareToFacebookDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_video(video),
    m_titleEdit(new QLineEdit(m_video.data()->title(), this)),
    m_descriptionEdit(new QTextEdit(m_video.data()->description(), this)),
    m_messageEdit(new QTextEdit(this)),
    m_scrollArea(new QScrollArea(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Share to facebook"));

    QLabel *titleLabel = new QLabel(tr("Title"), this);
    QLabel *descriptionLabel = new QLabel(tr("Description"), this);
    QLabel *messageLabel = new QLabel(tr("Message"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(titleLabel);
    vbox->addWidget(m_titleEdit);
    vbox->addWidget(descriptionLabel);
    vbox->addWidget(m_descriptionEdit);
    vbox->addWidget(messageLabel);
    vbox->addWidget(m_messageEdit);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(shareVideo()));

    this->onOrientationChanged();
}

void ShareToFacebookDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void ShareToFacebookDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void ShareToFacebookDialog::shareVideo() {
    QVariantMap share;
    share.insert("title", m_titleEdit->text());
    share.insert("description", m_descriptionEdit->toPlainText());
    share.insert("body", m_messageEdit->toPlainText());
    share.insert("videoId", m_video.data()->videoId());
    share.insert("vidoeUrl", m_video.data()->url());
    share.insert("thumbnailUrl", m_video.data()->largeThumbnailUrl());
    share.insert("embedUrl", m_video.data()->embedUrl());

    m_session->sharing()->postToFacebook(share);
    this->accept();
}
