#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"

class Session;
class MediaPlayerSelector;
class ConcurrentTransfersSelector;
class ScreenOrientationSelector;
class LanguageSelector;
class PlaybackQualityDialog;
class DownloadQualityDialog;
class SearchOptionsDialog;
class NetworkProxyDialog;
class QCheckBox;
class QLineEdit;
class QPushButton;
class QScrollArea;
class QDialogButtonBox;
class QGridLayout;
class QMaemo5ValueButton;

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit SettingsDialog(Session *session, QWidget *parent = 0);

private slots:
    void saveSettings();
    void showFileDialog();
    void showSearchOptionsDialog();
    void showPlaybackQualityDialog();
    void showDownloadQualityDialog();
    void showNetworkProxyDialog();
    void setYouTubePrivateAccess(bool enable);
    void setDailymotionPrivateAccess(bool enable);
    void onMediaPlayerChanged(const QString &player);

private:
    void loadSettings();
    void setLandscapeLayout();
    void setPortraitLayout();
    void scheduleEvents();
    void clearEvents();
    
private:
    Session *m_session;
    QCheckBox *m_transferStatusCheckbox;
    QCheckBox *m_safeSearchCheckbox;
    QCheckBox *m_eventFeedCheckbox;
    QPushButton *m_searchButton;
    QPushButton *m_playbackButton;
    QPushButton *m_downloadButton;
    QPushButton *m_proxyButton;
    QMaemo5ValueButton *m_downloadFolderSelector;
    QString m_downloadPath;
    MediaPlayerSelector *m_mediaPlayerSelector;
    ConcurrentTransfersSelector *m_concurrentSelector;
    ScreenOrientationSelector *m_orientationSelector;
    LanguageSelector *m_languageSelector;
    QLineEdit *m_mediaPlayerCommandEdit;
    QCheckBox *m_youtubePrivateCheckbox;
    QCheckBox *m_dailymotionPrivateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QScrollArea *m_scrollArea;
    PlaybackQualityDialog *m_playbackDialog;
    DownloadQualityDialog *m_downloadDialog;
    SearchOptionsDialog *m_searchDialog;
    NetworkProxyDialog *m_proxyDialog;
    QGridLayout *m_grid;
    bool m_eventFeedEnabled;
};

#endif // SETTINGSDIALOG_H
