#ifndef PLAYBACKVIDEOSELECTIONWINDOW_H
#define PLAYBACKVIDEOSELECTIONWINDOW_H

#include <QWidget>

class Session;
class ListView;
class QModelIndex;
class QMaemo5EditBar;
class QPushButton;
class QVBoxLayout;

class PlaybackVideoSelectionWindow : public QWidget
{
    Q_OBJECT
public:
    explicit PlaybackVideoSelectionWindow(Session *session, const QString &text, const char* slot, QWidget *parent);
    ~PlaybackVideoSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void addVideoDownloads();
    void addAudioDownloads();
    void removeVideos();

signals:
    void accepted();

private:
    Session *m_session;
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // PLAYBACKVIDEOSELECTIONWINDOW_H
