#ifndef DAILYMOTIONVIDEOSELECTIONWINDOW_H
#define DAILYMOTIONVIDEOSELECTIONWINDOW_H

#include "../base/enums.h"
#include <QWidget>
#include <QVariantMap>

class DailymotionVideoListModel;
class Session;
class ListView;
class QMaemo5EditBar;
class QPushButton;
class QVBoxLayout;
class QModelIndex;

class DailymotionVideoSelectionWindow : public QWidget
{
    Q_OBJECT
public:
    explicit DailymotionVideoSelectionWindow(Session *session, DailymotionVideoListModel *model, const QString &text, const char* slot, QWidget *parent);
    ~DailymotionVideoSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void showPlaylistDialog();
    void addVideosToPlaylist(const QString &id);
    void addVideosToNewPlaylist(const QVariantMap &playlist);
    void deleteVideosFromPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();

signals:
    void accepted();

private:
    Session *m_session;
    DailymotionVideoListModel *m_model;
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // DAILYMOTIONVIDEOSELECTIONWINDOW_H
