#ifndef DAILYMOTIONPRIVATEAUTHDIALOG_H
#define DAILYMOTIONPRIVATEAUTHDIALOG_H

#include "abstractdialog.h"

class Session;
class CookieJar;
class WebView;
class QProgressBar;
class QGridLayout;
class QUrl;

class DailymotionPrivateAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionPrivateAuthDialog(Session *session, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void checkUrl(const QUrl &url);

private:
    CookieJar *m_jar;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPRIVATEAUTHDIALOG_H
