#ifndef DAILYMOTIONAUTHDIALOG_H
#define DAILYMOTIONAUTHDIALOG_H

#include "abstractdialog.h"

class Session;
class WebView;
class QProgressBar;
class QGridLayout;
class QUrl;

class DailymotionAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionAuthDialog(Session *session, const QString &accountName, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void checkUrlForCode(const QUrl &url);

private:
    Session *m_session;
    QString m_name;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONAUTHDIALOG_H
