#ifndef YOUTUBESUBSCRIPTIONLISTMODEL_H
#define YOUTUBESUBSCRIPTIONLISTMODEL_H

#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class Session;
class ThumbnailCache;

class YouTubeSubscriptionListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
        AvatarRole,
        AvatarUrlRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit YouTubeSubscriptionListModel(Session *session = 0, QObject *parent = 0);
    ~YouTubeSubscriptionListModel();
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<UserItem> get(int row) const;
    Q_INVOKABLE UserItem* getFromQML(int row) const;

private slots:
    void onSubscriptionAdded(int row);
    void onSubscriptionRemoved(int row);
    void onThumbnailReady();

signals:
    void countChanged(int count);

private:
    Session *m_session;
    ThumbnailCache *m_cache;
};

#endif // YOUTUBESUBSCRIPTIONLISTMODEL_H
