#ifndef VIMEOUSERLISTMODEL_H
#define VIMEOUSERLISTMODEL_H

#include "abstractuserlistmodel.h"

class Session;

class VimeoUserListModel : public AbstractUserListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(QString feed
               READ feed
               WRITE setFeed)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)

public:
    explicit VimeoUserListModel(Session *session = 0, QObject *parent = 0);
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    inline QString feed() const { return m_feed; }
    void setFeed(const QString &feed);
    inline bool loading() const { return m_loading; }
    Q_INVOKABLE UserItem* getFromQML(int row) const;

public slots:
    void clear();
    void reset();
    void getUsers(const QString &feed = QString());
    void getMoreUsers();

private slots:
    void addUsers();
    inline void onError() { setError(true); setLoading(false); }

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);

private:
    Session *m_session;
    QString m_feed;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // VIMEOUSERLISTMODEL_H
