#include "vimeouserlistmodel.h"
#include "feedurls.h"
#include "session.h"
#include <QNetworkReply>
#include <QNetworkRequest>

VimeoUserListModel::VimeoUserListModel(Session *session, QObject *parent) :
    AbstractUserListModel(!session ? 0 : session->newThumbnailCache(), parent),
    m_session(session),
    m_loading(true),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void VimeoUserListModel::setSession(Session *session) {
    m_session = session;
}

void VimeoUserListModel::clear() {
    AbstractUserListModel::clear();
    this->setLoading(false);
    this->setOffset(1);
    this->setMoreResults(true);
    this->setError(false);
}

void VimeoUserListModel::reset() {
    if (!this->loading()) {
        this->clear();
        this->getMoreUsers();
    }
}

void VimeoUserListModel::setFeed(const QString &feed) {
    if (feed != this->feed()) {
        m_feed = feed;
    }
}

void VimeoUserListModel::getUsers(const QString &feed) {
    if (!feed.isEmpty()) {
        this->setFeed(feed);
    }

    this->setLoading(true);
    QNetworkReply *reply = this->session()->vimeo()->createReply(this->feed(), this->offset());
    this->connect(reply, SIGNAL(finished()), this, SLOT(addUsers()));
}

void VimeoUserListModel::addUsers() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        this->setLoading(false);
        this->setError(true);
        return;
    }

    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement responseNode = doc.firstChildElement("rsp");

    if (responseNode.attribute("stat") == "ok") {
        QDomNodeList entries = doc.elementsByTagName("contact");

        for (int i = 0; i < entries.size(); i++) {
            UserItem *user = new UserItem;
            user->loadVimeoContact(entries.at(i).toElement());
            this->connect(this->session()->vimeo(), SIGNAL(subscriptionChanged(QString,bool)), user, SLOT(onSubscriptionChanged(QString,bool)));
            this->appendUser(QSharedPointer<UserItem>(user));
        }

        QDomElement statNode = responseNode.firstChildElement("contacts");

        this->setLoading(false);
        this->setMoreResults(statNode.attribute("total").toInt() > this->rowCount());
        this->setOffset(statNode.attribute("page").toInt() + 1);

        emit countChanged(this->rowCount());
    }
    else {
        this->setLoading(false);
        this->setError(true);
    }

    reply->deleteLater();
}

void VimeoUserListModel::getMoreUsers() {
    if ((this->moreResults()) && (!this->loading())) {
        this->getUsers();
    }
}

UserItem* VimeoUserListModel::getFromQML(int row) const {
    if (UserItem *user = AbstractUserListModel::getFromQML(row)) {
        this->connect(this->session()->vimeo(), SIGNAL(subscriptionChanged(QString,bool)), user, SLOT(onSubscriptionChanged(QString,bool)));

        return user;
    }

    return 0;
}
