#ifndef VIDEOITEM_H
#define VIDEOITEM_H

#include "enums.h"
#include <QObject>
#include <QVariantMap>
#include <QUrl>
#include <QStringList>
#include <QDomElement>

class VideoItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString videoId
               READ videoId
               CONSTANT)
    Q_PROPERTY(QString favouriteId
               READ favouriteId
               NOTIFY favouriteChanged)
    Q_PROPERTY(QString playlistVideoId
               READ playlistVideoId
               CONSTANT)
    Q_PROPERTY(QUrl url
               READ url
               CONSTANT)
    Q_PROPERTY(QUrl embedUrl
               READ embedUrl
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               WRITE setTitle
               NOTIFY titleChanged)
    Q_PROPERTY(QString artist
               READ artist
               CONSTANT)
    Q_PROPERTY(QString artistId
               READ artistId
               CONSTANT)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               CONSTANT)
    Q_PROPERTY(QString description
               READ description
               WRITE setDescription
               NOTIFY descriptionChanged)
    Q_PROPERTY(int duration
               READ duration
               CONSTANT)
    Q_PROPERTY(QString date
               READ date
               CONSTANT)
    Q_PROPERTY(QStringList tags
               READ tags
               WRITE setTags
               NOTIFY tagsChanged)
    Q_PROPERTY(int likes
               READ likes
               WRITE setLikes
               NOTIFY likesChanged)
    Q_PROPERTY(int dislikes
               READ dislikes
               WRITE setDislikes
               NOTIFY dislikesChanged)
    Q_PROPERTY(int rating
               READ rating
               WRITE setRating
               NOTIFY ratingChanged)
    Q_PROPERTY(int ratingCount
               READ ratingCount
               WRITE setRatingCount
               NOTIFY ratingCountChanged)
    Q_PROPERTY(int viewCount
               READ viewCount
               WRITE setViewCount
               NOTIFY viewCountChanged)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               CONSTANT)
    Q_PROPERTY(QUrl largeThumbnailUrl
               READ largeThumbnailUrl
               CONSTANT)
    Q_PROPERTY(QString filePath
               READ filePath
               CONSTANT)
    Q_PROPERTY(qint64 fileSize
               READ fileSize
               CONSTANT)
    Q_PROPERTY(qint64 lastModified
               READ lastModified
               CONSTANT)
    Q_PROPERTY(bool liked
               READ liked
               NOTIFY likedChanged)
    Q_PROPERTY(bool disliked
               READ disliked
               NOTIFY dislikedChanged)
    Q_PROPERTY(bool favourite
               READ favourite
               WRITE setFavourite
               NOTIFY favouriteChanged)
    Q_PROPERTY(bool downloaded
               READ downloaded
               WRITE setDownloaded
               NOTIFY downloadedChanged)
    Q_PROPERTY(bool isPrivate
               READ isPrivate
               WRITE setPrivate
               NOTIFY isPrivateChanged)
    Q_PROPERTY(Services::VideoService service
               READ service
               CONSTANT)


public:
    explicit VideoItem(QObject *parent = 0);
    explicit VideoItem(VideoItem *video, QObject *parent = 0);
    ~VideoItem() {}
    void loadDailymotionVideo(const QVariantMap &video, bool favourite = false);
    void loadYouTubeVideo(const QDomNode &video, bool favourite = false);
    void loadVimeoVideo(const QDomElement &video);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString videoId() const { return m_videoId; }
    inline void setVideoId(const QString &id) { m_videoId = id; }
    inline QString favouriteId() const { return m_favouriteId; }
    inline void setFavouriteId(const QString &id) { m_favouriteId = id; }
    inline QString playlistVideoId() const { return m_playlistId; }
    inline void setPlaylistVideoId(const QString &id) { m_playlistId = id; }
    inline QUrl url() const { return m_url; }
    inline void setUrl(const QUrl &url) { m_url = url; }
    inline QUrl embedUrl() const { return m_embedUrl; }
    inline void setEmbedUrl(const QUrl &url) { m_embedUrl = url; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(title); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline int duration() const { return m_duration; }
    inline void setDuration(int duration) { m_duration = duration; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline QStringList tags() const { return m_tags; }
    inline void setTags(const QStringList &tags) { m_tags = tags; emit tagsChanged(tags); }
    inline int likes() const { return m_likes; }
    inline void setLikes(int likes) { m_likes = likes; emit likesChanged(likes); }
    inline int dislikes() const { return m_dislikes; }
    inline void setDislikes(int dislikes) { m_dislikes = dislikes; emit dislikesChanged(dislikes); }
    inline int rating() const { return m_rating; }
    inline void setRating(int rating) { m_rating = rating; emit ratingChanged(rating); }
    inline int ratingCount() const { return m_ratingCount; }
    inline void setRatingCount(int count) { m_ratingCount = count; emit ratingCountChanged(count); }
    inline int viewCount() const { return m_viewCount; }
    inline void setViewCount(int count) { m_viewCount = count; emit viewCountChanged(count); }
    inline QUrl thumbnailUrl() const { return m_thumbUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbUrl = url; }
    inline QUrl largeThumbnailUrl() const { return m_largeThumbUrl; }
    inline void setLargeThumbnailUrl(const QUrl &url) { m_largeThumbUrl = url; }
    inline QString filePath() const { return m_filepath; }
    inline void setFilePath(const QString &filePath) { m_filepath = filePath; }
    inline qint64 fileSize() const { return m_filesize; }
    inline void setFileSize(qint64 size) { m_filesize = size; }
    inline qint64 lastModified() const { return m_lastModified; }
    inline void setLastModified(qint64 date) { m_lastModified = date; }
    inline bool liked() const { return m_liked; }
    inline void like() { m_liked = true; this->setLikes(this->likes() + 1); emit likedChanged(true); }
    inline bool disliked() const { return m_disliked; }
    inline void dislike() { m_disliked = true; this->setDislikes(this->dislikes() + 1); emit dislikedChanged(true); }
    inline bool favourite() const { return m_favourite; }
    inline void setFavourite(bool isFavourite) { m_favourite = isFavourite; emit favouriteChanged(isFavourite); }
    inline bool downloaded() const { return m_downloaded; }
    inline void setDownloaded(bool downloaded) { m_downloaded = downloaded; emit downloadedChanged(downloaded); }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; emit isPrivateChanged(isPrivate); }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; }

public slots:
    void onFavouriteChanged(const QString &videoId, bool favourite, const QString &favouriteId = QString());
    void onVideoLiked(const QString &videoId);
    void onVideoDisliked(const QString &videoId);

signals:
    void titleChanged(const QString &title);
    void descriptionChanged(const QString &description);
    void tagsChanged(const QStringList &tags);
    void likesChanged(int likes);
    void dislikesChanged(int dislikes);
    void ratingChanged(int rating);
    void ratingCountChanged(int count);
    void viewCountChanged(int count);
    void likedChanged(bool liked);
    void dislikedChanged(bool disliked);
    void favouriteChanged(bool favourite);
    void downloadedChanged(bool downloaded);
    void isPrivateChanged(bool isPrivate);

private:
    QString m_id;
    QString m_videoId;
    QString m_favouriteId;
    QString m_playlistId;
    QUrl m_url;
    QUrl m_embedUrl;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    int m_duration;
    QString m_date;
    QStringList m_tags;
    int m_likes;
    int m_dislikes;
    int m_ratingCount;
    int m_rating;
    int m_viewCount;
    QUrl m_thumbUrl;
    QUrl m_largeThumbUrl;
    QString m_filepath;
    qint64 m_filesize;
    qint64 m_lastModified;
    bool m_liked;
    bool m_disliked;
    bool m_favourite;
    bool m_downloaded;
    bool m_private;
    Services::VideoService m_service;
};

#endif // VIDEOITEM_H
