#ifndef PLAYLISTITEM_H
#define PLAYLISTITEM_H

#include <QObject>
#include <QUrl>
#include <QDomElement>
#include <QVariantMap>

class PlaylistItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString playlistId
               READ playlistId
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               WRITE setTitle
               NOTIFY titleChanged)
    Q_PROPERTY(QString artist
               READ artist
               CONSTANT)
    Q_PROPERTY(QString artistId
               READ artistId
               CONSTANT)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               CONSTANT)
    Q_PROPERTY(QString description
               READ description
               WRITE setDescription
               NOTIFY descriptionChanged)
    Q_PROPERTY(int duration
               READ duration
               WRITE setDuration
               NOTIFY durationChanged)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               CONSTANT)
    Q_PROPERTY(QString date
               READ date
               CONSTANT)
    Q_PROPERTY(int videoCount
               READ videoCount
               WRITE setVideoCount
               NOTIFY videoCountChanged)
    Q_PROPERTY(bool isPrivate
               READ isPrivate
               WRITE setPrivate
               NOTIFY isPrivateChanged)

public:
    explicit PlaylistItem(QObject *parent = 0);
    explicit PlaylistItem(PlaylistItem *playlist, QObject *parent = 0);
    ~PlaylistItem() {}
    void loadDailymotionPlaylist(const QVariantMap &playlist);
    void loadYouTubePlaylist(const QDomNode &playlist);
    void loadVimeoAlbum(const QDomElement &album);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString playlistId() const { return m_playlistId; }
    inline void setPlaylistId(const QString &id) { m_playlistId = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(title); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline int duration() const { return m_duration; }
    inline void setDuration(int duration) { m_duration = duration; emit durationChanged(duration); }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(count); }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; emit isPrivateChanged(isPrivate); }

signals:
    void titleChanged(const QString &title);
    void descriptionChanged(const QString &description);
    void durationChanged(int duration);
    void videoCountChanged(int count);
    void isPrivateChanged(bool isPrivate);

private:
    QString m_id;
    QString m_playlistId;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    int m_duration;
    QString m_date;
    QUrl m_thumbnailUrl;
    int m_videoCount;
    bool m_private;
};

#endif // PLAYLISTITEM_H
