#include "playbacklistmodel.h"
#include "session.h"
#ifdef QML_USER_INTERFACE
#include <QDeclarativeEngine>
#endif
#include <QDebug>

PlaybackListModel::PlaybackListModel(Session *session, QObject *parent) :
    AbstractVideoListModel(0, parent),
    m_session(session)
{
#ifndef QML_USER_INTERFACE
    if (this->session()) {
        this->setThumbnailCache(this->session()->newThumbnailCache());
    }
#endif
}

void PlaybackListModel::insertVideo(int row, QSharedPointer<VideoItem> video) {
    AbstractVideoListModel::insertVideo(row, QSharedPointer<VideoItem>(video));
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::insertVideoFromQML(int row, VideoItem *video) {
#ifdef QML_USER_INTERFACE
    QSharedPointer<VideoItem> newVideo(new VideoItem(video));

    if (newVideo.data()->service() == Services::YouTube) {
        this->connect(this->session()->youtube(), SIGNAL(favouriteChanged(QString,bool,QString)), newVideo.data(), SLOT(onFavouriteChanged(QString,bool,QString)));
        this->connect(this->session()->youtube(), SIGNAL(videoLiked(QString)), newVideo.data(), SLOT(onVideoLiked(QString)));
        this->connect(this->session()->youtube(), SIGNAL(videoDisliked(QString)), newVideo.data(), SLOT(onVideoDisliked(QString)));
    }
    else if (newVideo.data()->service() == Services::Dailymotion) {
        this->connect(this->session()->dailymotion(), SIGNAL(favouriteChanged(QString,bool)), newVideo.data(), SLOT(onFavouriteChanged(QString,bool)));
    }

    AbstractVideoListModel::insertVideo(row, newVideo);
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
#else
    Q_UNUSED(row)
    Q_UNUSED(video)

    qWarning() << "Use the QSharedPointer, Luke.";
#endif
}

void PlaybackListModel::addVideo(QSharedPointer<VideoItem> video) {
    AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(video));
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::addVideoFromQML(VideoItem *video) {
#ifdef QML_USER_INTERFACE
    QSharedPointer<VideoItem> newVideo(new VideoItem(video));

    if (newVideo.data()->service() == Services::YouTube) {
        this->connect(this->session()->youtube(), SIGNAL(favouriteChanged(QString,bool,QString)), newVideo.data(), SLOT(onFavouriteChanged(QString,bool,QString)));
        this->connect(this->session()->youtube(), SIGNAL(videoLiked(QString)), newVideo.data(), SLOT(onVideoLiked(QString)));
        this->connect(this->session()->youtube(), SIGNAL(videoDisliked(QString)), newVideo.data(), SLOT(onVideoDisliked(QString)));
    }
    else if (newVideo.data()->service() == Services::Dailymotion) {
        this->connect(this->session()->dailymotion(), SIGNAL(favouriteChanged(QString,bool)), newVideo.data(), SLOT(onFavouriteChanged(QString,bool)));
    }

    AbstractVideoListModel::appendVideo(newVideo);
    emit alert(tr("Video added to playback queue"));
    emit countChanged(this->rowCount());
#else
    Q_UNUSED(video)

    qWarning() << "Use the QSharedPointer, Luke.";
#endif
}

void PlaybackListModel::addVideos(QList< QSharedPointer<VideoItem> > videos) {
    while (!videos.isEmpty()) {
        AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(videos.takeFirst()));
    }

    emit alert(tr("Videos added to playback queue"));
    emit countChanged(this->rowCount());
}

void PlaybackListModel::addVideosFromQML(QList<VideoItem *> videos) {
#ifdef QML_USER_INTERFACE
    while (!videos.isEmpty()) {
        QSharedPointer<VideoItem> newVideo(new VideoItem(videos.takeFirst()));

        if (newVideo.data()->service() == Services::YouTube) {
            this->connect(this->session()->youtube(), SIGNAL(favouriteChanged(QString,bool,QString)), newVideo.data(), SLOT(onFavouriteChanged(QString,bool,QString)));
            this->connect(this->session()->youtube(), SIGNAL(videoLiked(QString)), newVideo.data(), SLOT(onVideoLiked(QString)));
            this->connect(this->session()->youtube(), SIGNAL(videoDisliked(QString)), newVideo.data(), SLOT(onVideoDisliked(QString)));
        }
        else if (newVideo.data()->service() == Services::Dailymotion) {
            this->connect(this->session()->dailymotion(), SIGNAL(favouriteChanged(QString,bool)), newVideo.data(), SLOT(onFavouriteChanged(QString,bool)));
        }

        AbstractVideoListModel::appendVideo(newVideo);
    }

    emit alert(tr("Videos added to playback queue"));
    emit countChanged(this->rowCount());
#else
    Q_UNUSED(videos)

    qWarning() << "Use the QSharedPointer, Luke.";
#endif
}

void PlaybackListModel::removeVideo(int row) {
    this->removeRow(row);
    emit countChanged(this->rowCount());
}

void PlaybackListModel::removeSelectedVideos() {
    qSort(m_selectedRows.begin(), m_selectedRows.end(), qGreater<int>());

    for (int i = 0; i < m_selectedRows.size(); i++) {
        this->removeVideo(m_selectedRows.at(i));
    }

    this->selectNone();
    emit countChanged(this->rowCount());
}

void PlaybackListModel::downloadSelectedVideos(bool saveAsAudio) {
    this->session()->addDownloadTransfers(this->selectedItems(), saveAsAudio);
    this->selectNone();
}

VideoItem* PlaybackListModel::getFromQML(int row) const {
    if (VideoItem *video = AbstractVideoListModel::getFromQML(row)) {
        if (video->service() == Services::YouTube) {
            this->connect(this->session()->youtube(), SIGNAL(favouriteChanged(QString,bool,QString)), video, SLOT(onFavouriteChanged(QString,bool,QString)));
            this->connect(this->session()->youtube(), SIGNAL(videoLiked(QString)), video, SLOT(onVideoLiked(QString)));
            this->connect(this->session()->youtube(), SIGNAL(videoDisliked(QString)), video, SLOT(onVideoDisliked(QString)));
        }
        else if (video->service() == Services::Dailymotion) {
            this->connect(this->session()->dailymotion(), SIGNAL(favouriteChanged(QString,bool)), video, SLOT(onFavouriteChanged(QString,bool)));
        }

        return video;
    }

    return 0;
}
