#ifndef DAILYMOTIONPLAYLISTLISTMODEL_H
#define DAILYMOTIONPLAYLISTLISTMODEL_H

#include "abstractplaylistlistmodel.h"
#include "enums.h"

class Session;

class DailymotionPlaylistListModel : public AbstractPlaylistListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QString feed
               READ feed
               WRITE setFeed)

public:
    explicit DailymotionPlaylistListModel(Session *session = 0, QObject *parent = 0);
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    inline QString feed() const { return m_feed; }
    void setFeed(const QString &feed);
    inline bool loading() const { return m_loading; }

public slots:
    void clear();
    void reset();
    void getPlaylists(const QString &feed = QString());
    void getMorePlaylists();
    void search(const QString &query = QString(), int order = Queries::Relevance);

private slots:
    void addPlaylists();
    inline void onError() { setError(true); setLoading(false); }

private:
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline int order() const { return m_order; }
    inline void setOrder(int order) { m_order = order; }
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
   void loadingChanged(bool loading);
   void countChanged(int count);

private:
    Session *m_session;
    QString m_feed;
    QString m_query;
    int m_order;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // DAILYMOTIONPLAYLISTLISTMODEL_H
