#ifndef COMMENTITEM_H
#define COMMENTITEM_H

#include <QObject>
#include <QUrl>
#include <QDomElement>
#include <QVariantMap>

class CommentItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString body
               READ body
               WRITE setBody
               NOTIFY bodyChanged)
    Q_PROPERTY(QString artist
               READ artist
               CONSTANT)
    Q_PROPERTY(QString artistId
               READ artistId
               CONSTANT)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               CONSTANT)
    Q_PROPERTY(QString date
               READ date
               CONSTANT)
    Q_PROPERTY(QString videoId
               READ videoId
               WRITE setVideoId
               NOTIFY videoIdChanged)
    Q_PROPERTY(QString replyId
               READ replyId
               WRITE setReplyId
               NOTIFY replyIdChanged)

public:
    explicit CommentItem(QObject *parent = 0);
    explicit CommentItem(CommentItem *comment, QObject *parent = 0);
    ~CommentItem() {}
    void loadDailymotionComment(const QVariantMap &comment);
    void loadYouTubeComment(const QDomNode &comment);
    void loadVimeoComment(const QDomElement &comment);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString body() const { return m_body; }
    inline void setBody(const QString &body) { m_body = body; emit bodyChanged(body); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline QString videoId() const { return m_videoId; }
    inline void setVideoId(const QString &id) { m_videoId = id; emit videoIdChanged(id); }
    inline QString replyId() const { return m_replyId; }
    inline void setReplyId(const QString &id) { m_replyId = id; emit replyIdChanged(id); }
    inline int indent() const { return m_indent; }
    inline void setIndent(int indent) { m_indent = indent; }
    inline bool loading() const { return m_loading; }
    inline void setLoading(bool loading) { m_loading = loading; }

signals:
    void bodyChanged(const QString &body);
    void videoIdChanged(const QString &videoId);
    void replyIdChanged(const QString &replyId);

private:
    QString m_id;
    QString m_body;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_date;
    QString m_videoId;
    QString m_replyId;
    int m_indent;
    bool m_loading;
};

#endif // COMMENTITEM_H
