#include "commentitem.h"
#include "utils.h"

CommentItem::CommentItem(QObject *parent) :
    QObject(parent),
    m_indent(0),
    m_loading(false)
{
}

CommentItem::CommentItem(CommentItem *comment, QObject *parent) :
    QObject(parent),
    m_id(comment->id()),
    m_body(comment->body()),
    m_artist(comment->artist()),
    m_artistId(comment->artistId()),
    m_artistAvatarUrl(comment->artistAvatarUrl()),
    m_date(comment->date()),
    m_videoId(comment->videoId()),
    m_indent(comment->indent()),
    m_loading(comment->loading())
{
}

void CommentItem::loadDailymotionComment(const QVariantMap &comment) {
    this->setId(comment.value("id").toString());
    this->setBody(comment.value("message").toString());
    this->setArtist(comment.value("owner.username").toString());
    this->setArtistId(comment.value("owner.id").toString());
    this->setArtistAvatarUrl(comment.value("owner.avatar_medium_url").toString());
    this->setDate(Utils::dateFromSecs(comment.value("created_time").toLongLong()));
    this->setVideoId(comment.value("video.id").toString());
}

void CommentItem::loadYouTubeComment(const QDomNode &comment) {
    this->setId(comment.firstChildElement("id").text().section(':', -1));
    this->setBody(comment.firstChildElement("content").text());
    this->setArtist(comment.firstChildElement("author").firstChildElement("name").text());
    this->setArtistId(comment.firstChildElement("author").firstChildElement("yt:userId").text());
    this->setArtistAvatarUrl(QUrl(QString("http://i2.ytimg.com/i/%1/1.jpg").arg(this->artistId())));
    this->setDate(Utils::localDateTimeFromString(comment.firstChildElement("published").text()));
    this->setVideoId(comment.firstChildElement("yt:videoid").text());
    this->setReplyId(comment.firstChildElement("link").attribute("href").section('/', -1).section('?', 0, 0));
}

void CommentItem::loadVimeoComment(const QDomElement &comment) {
    this->setId(comment.attribute("id"));
    this->setDate(Utils::localDateTimeFromString(comment.attribute("datecreate")));
    this->setBody(comment.firstChildElement("text").text());
    QDomElement artistNode = comment.firstChildElement("author");
    this->setArtist(artistNode.attribute("display_name"));
    this->setArtistId(artistNode.attribute("id"));
    QDomNodeList avatars = artistNode.firstChildElement("portraits").childNodes();

    if (avatars.size() > 1) {
        this->setArtistAvatarUrl(QUrl(avatars.at(1).toElement().text()));
    }
}
