#ifndef ABSTRACTPLAYLISTLISTMODEL_H
#define ABSTRACTPLAYLISTLISTMODEL_H

#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class ThumbnailCache;

class AbstractPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        ThumbnailRole,
        ThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit AbstractPlaylistListModel(ThumbnailCache *cache = 0, QObject *parent = 0);
    ~AbstractPlaylistListModel();
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;
    void insertPlaylist(int row, QSharedPointer<PlaylistItem> playlist);
    void appendPlaylist(QSharedPointer<PlaylistItem> playlist);
    bool removePlaylist(const QVariant &value, int role = PlaylistIdRole);

public slots:
    void clear();
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<PlaylistItem> > m_list;
};

#endif // ABSTRACTPLAYLISTLISTMODEL_H
