TEMPLATE = app
QT += network sql xml webkit declarative
TARGET = cutetube

INSTALLS += target

SOURCES = $$files(src/base/*.cpp)
HEADERS = $$files(src/base/*.h)

maemo5 {
    #DEFINES += QML_USER_INTERFACE
    QT += maemo5 dbus
    CONFIG += mobility12
    MOBILITY += multimedia
    SOURCES += $$files(src/maemo5_gui/*.cpp)
    HEADERS += $$files(src/maemo5_gui/*.h)

    RESOURCES = src/maemo5_gui/resources.qrc

    desktopfile.path = /usr/share/applications/hildon
    desktopfile.files = desktop/cutetube_maemo5.desktop

    icon.path = /usr/share/icons/hicolor/64x64/apps
    icon.files = desktop/cutetube64.png

    translations.files += $$files(src/maemo5_gui/translations/*.*)
    translations.path += /opt/cutetube/translations

    dbus_service.files += dbus/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files += dbus/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    target.path = /opt/cutetube/bin

    INSTALLS += translations desktopfile icon dbus_service dbus_interface
}

symbian {
    DEFINES += QML_USER_INTERFACE
    MMP_RULES += "DEBUGGABLE_UDEBONLY"
    TARGET = cutetube_0x20068c69
    CONFIG += qt-components mobility
    MOBILITY += gallery
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.CAPABILITY += NetworkServices ReadUserData
    TARGET.UID3 = 0xE561674E //0x20068c69
    DEPLOYMENT.display_name = cuteTube
    VERSION = 1.7.1
    ICON = desktop/cutetube.svg

    my_deployment.pkg_prerules += vendorinfo

    DEPLOYMENT += my_deployment

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""

    folder_01.source = qml/symbian
    folder_01.target = qml
    DEPLOYMENTFOLDERS = folder_01

    SOURCES += $$files(src/symbian/*.cpp)
    HEADERS += $$files(src/symbian/*.h)

    include(src/qmlapplicationviewer/qmlapplicationviewer.pri)
    qtcAddDeployment()
}

contains(MEEGO_EDITION,harmattan) {
    DEFINES += QML_USER_INTERFACE
    QT+= opengl dbus
    CONFIG += qdeclarative-boostable \
        libtuiclient \
        libcontentaction \
        qdbus \
        shareuiinterface-maemo-meegotouch \
        share-ui-plugin \
        share-ui-common \
        mdatauri \
        mobility

    MOBILITY += gallery

    SOURCES += $$files(src/harmattan/*.cpp)
    HEADERS += $$files(src/harmattan/*.h)

    RESOURCES = qml/harmattan/resources.qrc

    folder_01.source = qml/harmattan
    folder_01.target = qml
    DEPLOYMENTFOLDERS = folder_01

    desktop_file.path = /usr/share/applications
    desktop_file.files = desktop/cutetube_harmattan.desktop

    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/cutetube80.png

    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/cutetube64.png

    dbus_service.files += dbus/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files += dbus/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    contentaction.files = contentaction/cutetube.xml
    contentaction.path = /usr/share/contentaction

    target.path = /opt/cutetube/bin

    resources.files += $$files(resources/*.*)
    resources.path = /opt/cutetube/resources

    INSTALLS += target desktop_file icon80 icon64 dbus_service dbus_interface contentaction resources

    include(src/qmlapplicationviewer/qmlapplicationviewer.pri)
    qtcAddDeployment()
}

simulator {
    DEFINES += QML_USER_INTERFACE
    folder_01.source = qml/maemo5
    folder_01.target = qml
    DEPLOYMENTFOLDERS = folder_01

    SOURCES += $$files(src/maemo5_qml/*.cpp)
    HEADERS += $$files(src/maemo5_qml/*.h)

    RESOURCES = qml/maemo5/resources.qrc

    include(src/qmlapplicationviewer/qmlapplicationviewer.pri)
    qtcAddDeployment()
}

#else {
#    DEFINES += QML_USER_INTERFACE
#    folder_01.source = qml/playbook
#    folder_01.target = qml
#    DEPLOYMENTFOLDERS = folder_01

#    SOURCES += $$files(src/playbook/*.cpp)
#    HEADERS += $$files(src/playbook/*.h)

##    package.target = $${TARGET}.bar
##    package.depends = $$TARGET
##    package.commands = blackberry-nativepackager \
##    -devMode -debugToken /home/stuart/Development/Blackberry/Playbook/debug_token.bar \
##    -package $${TARGET}.bar -arg -platform -arg blackberry \
##    bar-descriptor.xml $$TARGET \
##    -e $$[QT_INSTALL_LIBS]/libQtCore.so.4 lib/libQtCore.so.4 \
##    -e $$[QT_INSTALL_LIBS]/libQtGui.so.4 lib/libQtGui.so.4 \
##    -e $$[QT_INSTALL_LIBS]/libQtOpenGL.so.4 lib/libQtOpenGL.so.4 \
##    -e $$[QT_INSTALL_LIBS]/libQtNetwork.so.4 lib/libQtNetwork.so.4 \
##    -e $$[QT_INSTALL_PLUGINS]/platforms/libblackberry.so plugins/platforms/libblackberry.so

#    include(src/qmlapplicationviewer/qmlapplicationviewer.pri)
#    qtcAddDeployment()
#}
