#ifndef DATABASE_H
#define DATABASE_H

#include <QObject>
#include <QSqlDatabase>

class Database : public QObject
{
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    ~Database() {}
    void restoreAccounts();

public slots:
    void initialize();
    bool setYouTubeUsername(const QString &user);
    bool setYouTubeAccessToken(const QString &token);
    bool setDailymotionUsername(const QString &user);
    bool setDailymotionAccessToken(const QString &token, const QString &refresh);
    bool setVimeoUsername(const QString &user);
    bool setVimeoAccessToken(const QString &token, const QString &secret);

signals:
    void error(const QString &errorString);
    void gotYouTubeAccount(const QString &user, const QString &token, const QString &refresh);
    void gotDailymotionAccount(const QString &user, const QString &token, const QString &refresh);
    void gotVimeoAccount(const QString &user, const QString &token, const QString &secret);

private:
    void restoreYouTubeAccount();
    void restoreDailymotionAccount();
    void restoreVimeoAccount();
    void restoreFacebookAccount();
    void restoreTwitterAccount();

private:
    QSqlDatabase m_database;
};

#endif // DATABASE_H
