#ifndef YOUTUBEPROFILETAB_H
#define YOUTUBEPROFILETAB_H

#include "abstracttab.h"
#include "../base/useritem.h"

class Session;
class SeparatorLabel;
class AvatarLabel;
class QLabel;
class QPushButton;
class QScrollArea;
class QAction;
class QGridLayout;

class YouTubeProfileTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeProfileTab(Session *session, const QString &userId, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleSubscription();
    void onSubscribedChanged(bool subscribed);
    void showUserWebsite();
    void showUploadDialog();
    void showWatchLaterPlaylist();
    void showWatchHistory();
    
private:
    Session *m_session;
    QSharedPointer<UserItem> m_user;
    AvatarLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_videosLabel;
    QLabel *m_subscribersLabel;
    QLabel *m_viewsLabel;
    QLabel *m_locationLabel;
    QLabel *m_websiteLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_subscriptionButton;
    QAction *m_watchLaterAction;
    QAction *m_watchHistoryAction;
    QAction *m_uploadAction;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPROFILETAB_H
