#include "youtubeprivateauthdialog.h"
#include "../base/session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>
#include <QRegExp>

static const QUrl loginUrl("https://accounts.google.com/ServiceLogin?uilel=3&service=youtube&passive=true&continue=http://m.youtube.com/signin?action_handle_signin=true&nomobiletemp=1&warned=1&feature=mobile&ltmpl=mobile");
static const QRegExp urlRegExp("(^https://accounts.google.co.uk/accounts/SetSID|^http://m.youtube.com)", Qt::CaseInsensitive);

YouTubePrivateAuthDialog::YouTubePrivateAuthDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_jar(session->cookieJar()),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("YouTube authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->setNetworkAccessManager(session->networkAccessManager());
    m_webView->setUrl(loginUrl);
    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrl(QUrl)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    this->onOrientationChanged();
}

void YouTubePrivateAuthDialog::checkUrl(const QUrl &url) {
    if (urlRegExp.indexIn(url.toString()) >= 0) {
        m_jar->storeYouTubeCookies();
        this->accept();
    }
}
