#ifndef YOUTUBEMETADATADIALOG_H
#define YOUTUBEMETADATADIALOG_H

#include "abstractdialog.h"
#include "../base/videoitem.h"

class Session;
class YouTubeUploadCategorySelector;
class YouTubePermissionSelector;
class QLineEdit;
class QTextEdit;
class QPushButton;
class QCheckBox;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;

class YouTubeMetadataDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeMetadataDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleTextChanged(const QString &text);
    void onPrivateToggled(bool isPrivate);
    void setMetadata(const QVariantMap &metadata);
    void submitMetadata();
    
private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QLineEdit *m_tagsEdit;
    YouTubeUploadCategorySelector *m_categorySelector;
    YouTubePermissionSelector *m_responsesSelector;
    YouTubePermissionSelector *m_commentsSelector;
    QCheckBox *m_commentVoteCheckbox;
    QCheckBox *m_ratingsCheckbox;
    QCheckBox *m_privateCheckbox;
    QCheckBox *m_listingsCheckbox;
    QCheckBox *m_syndicationCheckbox;
    QCheckBox *m_autoPlayCheckbox;
    QCheckBox *m_embedCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBEMETADATADIALOG_H
