#ifndef VIMEOALBUMVIDEOSWINDOW_H
#define VIMEOALBUMVIDEOSWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"
#include "../base/videoitem.h"

class VimeoVideoListModel;
class ListView;
class ThumbnailLabel;
class SeparatorLabel;
class QAction;
class QLabel;
class QScrollArea;
class QPushButton;
class QModelIndex;

class VimeoAlbumVideosWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VimeoAlbumVideosWindow(Session *session, QSharedPointer<PlaylistItem> album, QWidget *parent);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void deleteVideosFromAlbum();
    void addVideosToLikes();
    void addVideosToAlbum();
    void addVideosToWatchLaterAlbum();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromAlbum();
    void addVideoToLikes();
    void showAlbumDialog();
    void addVideoToAlbum(const QString &id);
    void addVideoToNewAlbum(const QVariantMap &album);
    void addVideoToWatchLaterAlbum();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);
    void playAlbum();
    void setThumbnails();

private:
    QSharedPointer<PlaylistItem> m_album;
    ListView *m_listView;
    VimeoVideoListModel *m_model;
    QAction *m_deleteFromAlbumAction;
    QAction *m_addToLikesAction;
    QAction *m_addToAlbumAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromAlbumContextAction;
    QAction *m_addToLikesContextAction;
    QAction *m_addToAlbumContextAction;
    QAction *m_watchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    QPushButton *m_playButton;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    QScrollArea *m_scrollArea;
};

#endif // VIMEOALBUMVIDEOSWINDOW_H
