#include "dailymotionvideoselectionwindow.h"
#include "videoselectiondelegate.h"
#include "dailymotionplaylistdialog.h"
#include "../base/dailymotionvideolistmodel.h"
#include "../base/session.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>

DailymotionVideoSelectionWindow::DailymotionVideoSelectionWindow(Session *session, DailymotionVideoListModel *model, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_model(model),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select videos"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowFlags(Qt::Window);
    this->setWindowState(Qt::WindowFullScreen);
    this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VideoSelectionDelegate(m_listView));

    m_editBar->addButton(m_acceptButton);
    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    this->connect(this, SIGNAL(accepted()), this, slot);
}

DailymotionVideoSelectionWindow::~DailymotionVideoSelectionWindow() {
    m_model->selectNone();
}

void DailymotionVideoSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void DailymotionVideoSelectionWindow::onItemClicked(const QModelIndex &index) {
    m_model->toggleSelected(index.row());
}

void DailymotionVideoSelectionWindow::onButtonClicked() {
    if (m_model->itemsSelected()) {
        emit accepted();
    }
}

void DailymotionVideoSelectionWindow::deleteVideosFromUploads() {
    m_model->deleteSelectedVideosFromUploads();
    this->close();
}

void DailymotionVideoSelectionWindow::addVideosToFavourites() {
    m_model->addSelectedVideosToFavourites();
    this->close();
}

void DailymotionVideoSelectionWindow::deleteVideosFromFavourites() {
    m_model->deleteSelectedVideosFromFavourites();
    this->close();
}

void DailymotionVideoSelectionWindow::showPlaylistDialog() {
    DailymotionPlaylistDialog *dialog = new DailymotionPlaylistDialog(m_session, this);
    dialog->open();

    this->connect(dialog, SIGNAL(playlistChosen(QString)), this, SLOT(addVideosToPlaylist(QString)));
    this->connect(dialog, SIGNAL(addToNewPlaylist(QVariantMap)), this, SLOT(addVideosToNewPlaylist(QVariantMap)));
}

void DailymotionVideoSelectionWindow::addVideosToPlaylist(const QString &id) {
    m_model->addSelectedVideosToPlaylist(id);
    this->close();
}

void DailymotionVideoSelectionWindow::addVideosToNewPlaylist(const QVariantMap &playlist) {
    m_model->addSelectedVideosToNewPlaylist(playlist);
    this->close();
}

void DailymotionVideoSelectionWindow::deleteVideosFromPlaylist() {
    m_model->deleteSelectedVideosFromPlaylist(m_model->playlistId());
    this->close();
}

void DailymotionVideoSelectionWindow::addVideoDownloads() {
    m_model->downloadSelectedVideos();
    this->close();
}

void DailymotionVideoSelectionWindow::addAudioDownloads() {
    m_model->downloadSelectedVideos(true);
    this->close();
}

void DailymotionVideoSelectionWindow::queueVideos() {
    m_model->queueSelectedVideos();
    this->close();
}
