#ifndef EVENTS_H
#define EVENTS_H

#include "youtube.h"
#include "dailymotion.h"
#include "database.h"
#include "event.h"
#include <QNetworkAccessManager>
#include <QStringList>
#include <QDateTime>

class Events : public QObject
{
    Q_OBJECT

public:
    Events(QObject *parent = 0);
    ~Events() {}

public slots:
    void enableSync();
    void disableSync();
    void startSync();

private slots:
    void abortSync();
    void syncSuccess();
    void syncFailed();
    void getEvents();
    void getYouTubeEvents();
    void processYouTubeEvents();
    void getDailymotionEvents();
    void processDailymotionEvents();

private:
    void init();
    void addEvents();

private:
    QNetworkAccessManager *m_nam;
    Database *m_database;
    YouTube *m_youtube;
    Dailymotion *m_dailymotion;
    QList<Event> m_events;
    bool m_initialized;
    QDateTime m_lastRun;
    QDateTime m_thisRun;
};

#endif  //  EVENTS_H
