#ifndef SELECTIONMODELS_H
#define SELECTIONMODELS_H

#include "enums.h"
#include "transferitem.h"
#include <QStandardItemModel>

class SelectionModel : public QStandardItemModel
{
    Q_OBJECT

public:
    explicit SelectionModel(QObject *parent = 0);
    void addItem(const QString &name, const QVariant &value);
    QString name(int row) const;
    QVariant value(int row) const;
    inline Qt::Alignment textAlignment() const { return m_textAlignment; }
    inline void setTextAlignment(Qt::Alignment alignment) { m_textAlignment = alignment; }

private:
    Qt::Alignment m_textAlignment;
};

class SearchOrderModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit SearchOrderModel(QObject *parent = 0);
};

class SearchTypeModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit SearchTypeModel(QObject *parent = 0);
    void showGroups(bool show);
};

class SearchDurationModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit SearchDurationModel(QObject *parent = 0);
};

class SearchTimeModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit SearchTimeModel(QObject *parent = 0);
};

class VideoServiceModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit VideoServiceModel(QObject *parent = 0);
    void showExtras(bool show);
    void showXTube(bool show);
};

class MediaPlayerModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit MediaPlayerModel(QObject *parent = 0);
};

class ScreenOrientationModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit ScreenOrientationModel(QObject *parent = 0);
};

class TransferPriorityModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit TransferPriorityModel(QObject *parent = 0);
};

class YouTubePermissionModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit YouTubePermissionModel(QObject *parent = 0);
};

class YouTubeUploadCategoryModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit YouTubeUploadCategoryModel(QObject *parent = 0);
};

class DailymotionUploadCategoryModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit DailymotionUploadCategoryModel(QObject *parent = 0);
};

class SharingModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit SharingModel(QObject *parent = 0);
};

class LanguageModel : public SelectionModel
{
    Q_OBJECT

public:
    explicit LanguageModel(QObject *parent = 0);
};

#endif // SELECTIONMODELS_H
