#ifndef SEARCHDIALOG_H
#define SEARCHDIALOG_H

#include "abstractdialog.h"
#include "videoserviceselector.h"
#include "searchtypeselector.h"
#include "searchorderselector.h"
#include "searchtimeselector.h"
#include "searchdurationselector.h"
#include "languageselector.h"
#include "searchhistorydialog.h"
#include "settings.h"
#include <QLineEdit>
#include <QPushButton>
#include <QScrollArea>
#include <QDialogButtonBox>
#include <QGridLayout>

class SearchDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SearchDialog(Settings *settings, QWidget *parent = 0);

private slots:
    void showSearchHistory();
    void parseSearchQuery();
    void onServiceChanged(Services::VideoService service);
    void onSearchTypeChanged(Queries::QueryType type);
    void onSearchTextChanged(const QString &text);

private:
    QString clipboardUrl() const;
    void setLandscapeLayout();
    void setPortraitLayout();

signals:
    void search(const QString &query);
    void goToVideo(const QString &url);
    
private:
    Settings *m_settings;
    QLineEdit *m_searchEdit;
    VideoServiceSelector *m_searchServiceSelector;
    SearchTypeSelector *m_searchTypeSelector;
    SearchOrderSelector *m_searchOrderSelector;
    SearchTimeSelector *m_searchTimeSelector;
    SearchDurationSelector *m_searchDurationSelector;
    LanguageSelector *m_searchLanguageSelector;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_historyButton;
    QPushButton *m_searchButton;
    QScrollArea *m_scrollArea;
    SearchListModel *m_model;
    SearchHistoryDialog *m_historyDialog;
    QGridLayout *m_grid;
};

#endif // SEARCHDIALOG_H
