#ifndef HOMEWINDOW_H
#define HOMEWINDOW_H

#include "stackedwindow.h"
#include "navbutton.h"
#include <QGridLayout>
#include <QAction>

class HomeWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit HomeWindow(QWidget *parent = 0);

public slots:
    void displayVideo(const QString &url);
    void playVideo(const QString &url);

private slots:
    void showSettingsDialog();
    void showAboutDialog();
    void showMyChannel(Services::VideoService service = Services::NoService);
    void showLatestVideos(Services::VideoService service = Services::NoService);
    void showCategoriesDialog();
    void showCategoryVideos(Services::VideoService service, const QString &title, const QString &feed);
    void showSocialVideos();
    void showSearchDialog();
    void showPlaybackQueue();
    void showTransfers();
    void showArchive();
    void showAccounts();
    void search(const QString &query);
    void showYouTubeVideo(QSharedPointer<VideoItem> video);
    void showDailymotionVideo(QSharedPointer<VideoItem> video);
    void showVimeoVideo(QSharedPointer<VideoItem> video);
    void showLinkGoogleAccountDialog();
    void showFacebookAuthDialog();
    void showTwitterAuthDialog();

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showYouTubeChannel();
    void showDailymotionChannel();
    void showLatestYouTubeVideos();
    void showLatestDailymotionVideos();
    void showSignInDialog();
    void showSocialSignInDialog();

private:
    NavButton *m_myChannelButton;
    NavButton *m_latestButton;
    NavButton *m_categoriesButton;
    NavButton *m_socialButton;
    NavButton *m_searchButton;
    NavButton *m_queueButton;
    NavButton *m_transfersButton;
    NavButton *m_archiveButton;
    NavButton *m_accountsButton;
    QAction *m_accountsAction;
    QAction *m_settingsAction;
    QAction *m_aboutAction;
    QGridLayout *m_grid;
};

#endif // HOMEWINDOW_H
