#include "dailymotionsubscriptionstab.h"
#include "dailymotionuserlistdelegate.h"
#include "dailymotionchannelwindow.h"
#include "dailymotionvideolistwindow.h"

DailymotionSubscriptionsTab::DailymotionSubscriptionsTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_model(new DailymotionSubscriptionListModel(session, this)),
    m_listView(new ListView(this)),
    m_contextMenu(new QMenu(this)),
    m_unsubscribeAction(m_contextMenu->addAction(tr("Unsubscribe"), this, SLOT(unsubscribe()))),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new DailymotionUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (m_session->dailymotion()->subscriptionsLoaded()) {
        onSubscriptionsLoaded();
    }
    else {
        m_session->toggleBusy(true);
        connect(m_session->dailymotion(), SIGNAL(allSubscriptionsLoaded()), this, SLOT(onSubscriptionsLoaded()));
    }

    connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    onOrientationChanged();
}

void DailymotionSubscriptionsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionSubscriptionsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionSubscriptionsTab::onSubscriptionsLoaded() {
    m_session->toggleBusy(false);
    m_listView->setModel(m_model);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void DailymotionSubscriptionsTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showUserChannel(index.data(DailymotionSubscriptionListModel::IdRole).toString());
    }
}

void DailymotionSubscriptionsTab::showUserChannel(const QString &userId) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(m_session, userId, m_session->currentWindow());
    window->show();
}

void DailymotionSubscriptionsTab::showSubscriptionVideos() {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, m_session->currentWindow());
    window->setVideoFeed(DAILYMOTION_NEW_SUBSCRIPTION_VIDEOS_FEED);
    window->show();
}

void DailymotionSubscriptionsTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_unsubscribeAction);
}

void DailymotionSubscriptionsTab::unsubscribe() {
    m_session->dailymotion()->unsubscribe(m_model->get(m_listView->currentIndex().row()));
}
