#ifndef COMMENTDELEGATE_H
#define COMMENTDELEGATE_H

#include <QStyledItemDelegate>
#include <QListView>
#include <QPainter>

class CommentDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit CommentDelegate(QListView *parent);
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index);
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

signals:
    void showUserChannel(const QModelIndex &index);
    void getInitialComment(int row);
    
private:
    QListView *m_view;
    bool m_avatarPressed;
    bool m_arrowPressed;
};

#endif // COMMENTDELEGATE_H
