#include "avatarlabel.h"
#include <QPainter>

AvatarLabel::AvatarLabel(QWidget *parent) :
    QWidget(parent),
    m_interactive(false),
    m_pressed(false)
{
    setFixedSize(144, 178);
}

void AvatarLabel::setName(const QString &name) {
    m_name = name;
    repaint();
}

void AvatarLabel::setImage(const QImage &image) {
    m_image = image;
    repaint();
}

void AvatarLabel::mousePressEvent(QMouseEvent *event) {
    if (interactive()) {
        event->accept();
        m_pressed = true;
        repaint();
    }
    else {
        event->ignore();
    }
}

void AvatarLabel::mouseReleaseEvent(QMouseEvent *event) {
    if ((interactive()) && (rect().contains(event->pos()))) {
        event->accept();
        m_pressed = false;
        repaint();
        emit clicked();
    }
    else {
        event->ignore();
    }
}

void AvatarLabel::leaveEvent(QEvent *event) {
    event->accept();
    m_pressed = false;
    repaint();
}

void AvatarLabel::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QPainter painter(this);

    if (!m_image.isNull()) {
        QRect imageRect = rect();
        imageRect.setTopLeft(QPoint(imageRect.left() + 8, imageRect.top() + 8));
        imageRect.setSize(QSize(128, 128));

        painter.drawImage(imageRect, m_image);
    }

    if (m_pressed) {
        painter.drawImage(rect(), QImage("/etc/hildon/theme/images/ContactsAppletFrameActive.png"));
    }
    else {
        painter.drawImage(rect(), QImage("/etc/hildon/theme/images/ContactsAppletFrame.png"));
    }

    QRect textRect = rect();
    textRect.setTopLeft(QPoint(textRect.left() + 8, textRect.top() + 137));
    textRect.setSize(QSize(128, 36));

    QFont font;
    font.setPixelSize(18);
    painter.setFont(font);
    painter.setClipRect(textRect);

    if (!m_name.isEmpty()) {
        painter.drawText(textRect, Qt::AlignCenter, m_name);
    }
}
