#include "abstractuserlistmodel.h"

AbstractUserListModel::AbstractUserListModel(ThumbnailCache *cache, QObject *parent) :
    QAbstractListModel(parent),
    m_cache(cache)
{
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

AbstractUserListModel::~AbstractUserListModel() {
    m_list.clear();
    delete m_cache;
}

int AbstractUserListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_list.size();
}

QVariant AbstractUserListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_list.at(index.row()).data()->id();
    case SubscriptionIdRole:
        return m_list.at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return m_list.at(index.row()).data()->username();
    case ChannelNameRole:
        return m_list.at(index.row()).data()->channelName();
    case AvatarRole:
        return m_cache->thumbnail(m_list.at(index.row()).data()->avatarUrl(), QSize(60, 60));
    case VideoCountRole:
        return m_list.at(index.row()).data()->videoCount();
    case SubscriberCountRole:
        return m_list.at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return m_list.at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

QSharedPointer<UserItem> AbstractUserListModel::get(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return QSharedPointer<UserItem>(m_list.at(row));
    }

    return QSharedPointer<UserItem>();
}

void AbstractUserListModel::insertUser(int row, QSharedPointer<UserItem> user) {
    beginInsertRows(QModelIndex(), row, row);
    m_list.insert(row, user);
    endInsertRows();
}

void AbstractUserListModel::appendUser(QSharedPointer<UserItem> user) {
    beginInsertRows(QModelIndex(), rowCount(), rowCount());
    m_list.append(user);
    endInsertRows();
}

bool AbstractUserListModel::removeUser(const QString &id) {
    bool removed = false;
    int i = 0;

    while ((!removed) && (i < m_list.size())) {
        removed = (get(i).data()->id() == id);

        if (removed) {
            removeRow(i);
        }

        i++;
    }

    return removed;
}

bool AbstractUserListModel::removeRow(int row, const QModelIndex &parent)
{
    Q_UNUSED(parent);

    if ((row >= 0) && (row < m_list.size())) {
        beginRemoveRows(QModelIndex(), row, row);
        m_list.takeAt(row).clear();
        endRemoveRows();

        return true;
    }

    return false;
}

void AbstractUserListModel::onThumbnailReady() {
    emit dataChanged(index(0), index(rowCount() - 1));
}
