#ifndef VIMEO_H
#define VIMEO_H

#include "videoitem.h"
#include "enums.h"
#include <QObject>
#include <QNetworkAccessManager>

class Vimeo : public QObject
{
    Q_OBJECT

public:
    explicit Vimeo(QObject *parent = 0);
    inline QNetworkAccessManager *networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    void search(QString query, int offset = 1, Queries::QueryOrder order = Queries::Relevance);
    void getVideoInfo(QSharedPointer<VideoItem> video);
    void getFullVideo(QString id);

private slots:
    void parseVimeoPage();
    void checkVideoInfo();
    void checkFullVideo();
    
signals:
    void gotVideos(QList< QSharedPointer<VideoItem> > videos);
    void gotVideoInfo();
    void gotVideo(QSharedPointer<VideoItem> video);
    void busy(const QString &message, int numberOfOperations = 1);
    void busyProgressChanged(int progress);
    void error(const QString &errorString);

private:
    QNetworkAccessManager *m_nam;
    QHash<int, QString> m_queryOrders;
    QSharedPointer<VideoItem> m_videoAction;
};

#endif // VIMEO_H
