#ifndef VIDEOSERVICEDIALOG_H
#define VIDEOSERVICEDIALOG_H

#include "abstractdialog.h"
#include "selectionmodels.h"
#include "listview.h"
#include "enums.h"
#include <QGridLayout>

class VideoServiceDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit VideoServiceDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void valueChanged(Services::VideoService service);
    
private:
    VideoServiceModel *m_model;
    ListView *m_listView;
    QGridLayout *m_grid;
};

#endif // VIDEOSERVICEDIALOG_H
