#include "transferprioritydialog.h"
#include "textlistdelegate.h"

TransferPriorityDialog::TransferPriorityDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new TransferPriorityModel(this)),
    m_listView(new QListView(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Transfer priority"));

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::AlignCenter, m_listView));
    m_grid->addWidget(m_listView, 0, 0);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    onOrientationChanged();
}

void TransferPriorityDialog::setLandscapeLayout() {
    setFixedHeight(340);
}

void TransferPriorityDialog::setPortraitLayout() {
    setFixedHeight(600);
}

void TransferPriorityDialog::setValue(TransferItem::Priority priority) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<TransferItem::Priority>(m_model->value(i).toInt()) == priority;

        if (found) {
            m_listView->setCurrentIndex(m_model->index(i, 0));
        }

        i++;
    }

    if (!found) {
        m_listView->setCurrentIndex(m_model->index(0, 0));
    }

    emit valueChanged(static_cast<TransferItem::Priority>(m_model->value(m_listView->currentIndex().row()).toInt()));
}

TransferItem::Priority TransferPriorityDialog::currentValue() const {
    return static_cast<TransferItem::Priority>(m_model->value(m_listView->currentIndex().row()).toInt());
}

void TransferPriorityDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<TransferItem::Priority>(m_model->value(index.row()).toInt()));
    accept();
}
