#include "sharingdialog.h"
#include "textlistdelegate.h"

SharingDialog::SharingDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new SharingModel(this)),
    m_listView(new QListView(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Share video"));

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::AlignCenter, m_listView));
    m_grid->addWidget(m_listView, 0, 0);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    onOrientationChanged();
}

void SharingDialog::setLandscapeLayout() {
    setFixedHeight(340);
}

void SharingDialog::setPortraitLayout() {
    setFixedHeight(600);
}

Services::SharingService SharingDialog::currentValue() const {
    return static_cast<Services::SharingService>(m_model->value(m_listView->currentIndex().row()).toInt());
}

void SharingDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<Services::SharingService>(m_model->value(index.row()).toInt()));
    accept();
}
