#ifndef RATINGINDICATOR_H
#define RATINGINDICATOR_H

#include <QWidget>
#include <QPaintEvent>

class RatingIndicator : public QWidget
{
    Q_OBJECT
public:
    explicit RatingIndicator(int value = 0, int count = 0, QWidget *parent = 0);
    inline int minimum() const { return m_minimum; }
    inline int maximum() const { return m_maximum; }
    inline int value() const { return m_value; }
    inline int count() const { return m_count; }
    void paintEvent(QPaintEvent *event);

public slots:
    inline void setMinimum(int min) { m_minimum = min; }
    inline void setMaximum(int max) { m_maximum = max; }
    inline void setValue(int val) { m_value = val; }
    inline void setCount(int count) { m_count = count; }
    
private:
    int m_minimum;
    int m_maximum;
    int m_value;
    int m_count;
};

#endif // RATINGINDICATOR_H
